
#ifndef IIRSCRAM_BREAK_STATEMENT_HH
#define IIRSCRAM_BREAK_STATEMENT_HH

// Copyright (c) 2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Author: Harish Venkataramani venkath@ececs.uc.edu

#include "IIRBase_BreakStatement.hh"
#include "IIR_Label.hh"
#include "published_file.hh"

template <class type> class set;
class IIR_AboveAttribute;

/** The extension base for Sequential Break Statement. This notifies the
    analog solver that it must determine the discontinuity augmentation set
    for the next analog solution point. */
class IIRScram_BreakStatement : public IIRBase_BreakStatement {

public:
  /** @name Method for publishing VHDL code. */
  void _publish_vhdl(ostream &);

  /** @name C++ publishing methods.  These methods relate to the publishing
      of C++. */
  void _publish_cc(published_file &);
  void _publish_cc_ams();
 
  /** mangled_process_label is used to name the generated break
      signal. This mangled_process_label is obtained from the process name
      and these functions are used to set and return them respectively. */
  void _set_process_stmt_label(IIR_Label *);
  IIR_Label* _get_process_stmt_label();

  void _get_list_of_input_signals(set<IIR>* list);
  void _type_check();
  
  IIR_Boolean _is_above_attribute_found();
  void _build_above_attribute_set(set<IIR_AboveAttribute> *);

protected:
  IIRScram_BreakStatement(){} ;
  virtual ~IIRScram_BreakStatement() = 0;

private:
  IIR_Label *_mangled_process_label;

};
#endif
