
#ifndef IIRSCRAM_ARCHITECTURE_STATEMENT_LIST_HH
#define IIRSCRAM_ARCHITECTURE_STATEMENT_LIST_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Malolan Chetlur     
//          Timothy J. McBrayer 
//          Narayanan Thondugulam

//---------------------------------------------------------------------------

#include "IIRBase_ArchitectureStatementList.hh"

class IIRScram_ArchitectureStatementList : public IIRBase_ArchitectureStatementList {

public:
  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_cc( published_file &_cc_out );
  IIR_Boolean _publish_cc_type_info( published_file &_cc_out, IIR_Boolean = FALSE );
  void _publish_cc_extern_type_info( published_file &_cc_out );

  IIR_Label *_find_instantiate_label( IIR_SimpleName * );
  void _type_check_instantiate_statements();

  int _get_number_of_component_instantiations(  );
  
  /** Call "_publish_cc_instantiate" on all of the members of the list. */
  void _publish_cc_instantiate_calls( published_file &_cc_out );

  /** Function which helps in publishing the characteristic expressions */
  void _publish_cc_characteristic_expressions(published_file &);

  /** Publish the ams function's body and prototype */
  void _publish_cc_ams_function_body(published_file &);
  void _publish_cc_ams_function_prototype(published_file &);

  void _publish_cc_createNetInfo( published_file &_cc_out );

protected:
  IIRScram_ArchitectureStatementList() {};
  virtual ~IIRScram_ArchitectureStatementList() = 0;
    
private:
};
#endif
