
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_WaitStatement.hh"
#include "savant.hh"

IIRBase_WaitStatement::IIRBase_WaitStatement() :
  condition_clause(0),
  timeout_clause(0){}

IIRBase_WaitStatement::~IIRBase_WaitStatement(){
  delete get_condition_clause();
  delete get_timeout_clause();
}

void 
IIRBase_WaitStatement::set_condition_clause( IIR *new_condition_clause) {
  condition_clause = new_condition_clause;
}

IIR *
IIRBase_WaitStatement::get_condition_clause(){
  return condition_clause;
}

void 
IIRBase_WaitStatement::set_timeout_clause( IIR *new_timeout_clause) {
  timeout_clause = new_timeout_clause;
}

IIR *
IIRBase_WaitStatement::get_timeout_clause(){
  return timeout_clause;
}
