
#ifndef IIRBASE_TEXTLITERAL_HH
#define IIRBASE_TEXTLITERAL_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com

#include "IIR_Literal.hh"
#include "IIRScram_String.hh"

class IIR_Identifier;
class IIR_TextLiteral;

class IIRBase_TextLiteral : public IIR_Literal {

public:
  IIR_Char *get_text();
  IIR_Int32 get_text_length();

  IIR_Char &operator[]( IIR_Int32 subscript );

  /** Compares text literals. */
  static int _cmp(IIR_TextLiteral *a, IIR_TextLiteral *b);
  static int _cmp(IIR_TextLiteral *a, char *b);

  ostream &_print( ostream &os );

  /** This method converts an IIR_Identifier into a C++ string. */
  const string _convert_to_string();
  const string _convert_to_library_name();
 
protected:  
  IIRBase_TextLiteral();
  virtual ~IIRBase_TextLiteral() = 0;

  IIRScram_String *text;
    
private:  
  void _check_bounds( IIR_Int32 subscript );
};

#endif
