
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_FloatingSubtypeDefinition.hh"
#include "savant.hh"
#include "IIR_FloatingSubtypeDefinition.hh"

IIRBase_FloatingSubtypeDefinition::IIRBase_FloatingSubtypeDefinition() {
  my_resolution_function = NULL;
}

IIRBase_FloatingSubtypeDefinition::~IIRBase_FloatingSubtypeDefinition(){
  my_resolution_function = NULL;
}

IIR_FloatingSubtypeDefinition * 
IIRBase_FloatingSubtypeDefinition::get(
				       IIR_FloatingTypeDefinition* base_type, IIR* left_limit,
				       IIR* direction, IIR* right_limit) {

  IIR_FloatingSubtypeDefinition* retval = new IIR_FloatingSubtypeDefinition;
  retval->set_base_type(base_type);
  retval->set_left(left_limit);
  retval->set_right(right_limit);
  retval->set_direction(direction);

  return retval;
}


void
IIRBase_FloatingSubtypeDefinition::release() {
  delete this;
}

void 
IIRBase_FloatingSubtypeDefinition::set_resolution_function( IIR_FunctionDeclaration *resolution_function ){
  my_resolution_function = resolution_function;
}


IIR_FunctionDeclaration *
IIRBase_FloatingSubtypeDefinition::get_resolution_function(){
  return my_resolution_function;
}
