
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#ifndef __RDEBUG_H__
#define __RDEBUG_H__

#define ENABLE_EDEBUG 1



/* Documenation!
 *
 * The proper way to use this is use the RDEBUG macro.  This allows
 * all debug statements to be compiled right out of the code in
 * production mode, and so allow a fair speedup and data segment
 * savings.  The use require that you double parens the argument
 * though.  eg:
 *
 * RDEBUG (("domain", "hello %s", "world"));
 *
 * The first argument is the domain to which this debug message
 * belongs, and, and then a printf style formatted string for
 * the message.  rbuf_sprintf() is used for printing, so %b
 * for printing rbuf's will work.
 */

#ifdef ENABLE_EDEBUG
#define RDEBUG(x) rdebug x
#else
#define RDEBUG(x)
#endif /* ENABLE_EDEBUG */


void
rdebug_enable (char *domains);

void
rdebug (char *domain, char *format, ...);



#endif /* __RDEBUG_H__ */



