
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#include <roy.h>

typedef struct
{
    RLIST_HEADER;
    RBuf *domain;
} RDebugListEntry;

static int entity_debug = FALSE;
static RList *debug_domains = NULL;

static int
rdebug_check_domain (char *domain)
{
    RListOfRBufEntry *entry;

    if ((entity_debug == FALSE) || (!debug_domains))
        return (FALSE);

    RLIST_FOREACH(debug_domains, entry) {
        if ((rbuf_equal_str (entry->buf, domain)) ||
            (rbuf_equal_str (entry->buf, "all")))
            return (TRUE);
    } RFOREACH_CLOSE;

    return (FALSE);
}

void
rdebug_enable (char *domains)
{
    RListOfRBufEntry *entry;

    if (debug_domains) {
        RLIST_FOREACH(debug_domains, entry) {
            rbuf_free (entry->buf);
            rlist_of_rbuf_entry_free (entry);
        } RFOREACH_CLOSE;
        rlist_free (debug_domains);
    }
    
    if (domains == NULL) {
        debug_domains = NULL;
        entity_debug = FALSE;
        return;
    }
    
    entity_debug = TRUE;
    debug_domains = rstr_split (domains, ",", -1);
}

void				/* Freed MW */
rdebug (char *domain, char *format, ...)
{
    va_list args;
    RBuf *string;
    int should_log;

    if (entity_debug == FALSE)
        return;

    should_log = rdebug_check_domain (domain);

    if (!should_log)
        return;

    string = rbuf_new ();

    va_start (args, format);
    rbuf_append_vsprintf (string, format, args);
    va_end (args);

    printf ("DEBUG: %s: %s\n", domain, rbuf_str (string));
    rbuf_free (string);
}



