/* 
 * main.c --
 *
 *      This file contains the main program for "wish", a windowing
 *      shell based on Tk and Tcl.  It also provides a template that
 *      can be used as the basis for main programs for other Tk
 *      applications.
 *
 * Copyright (c) 1990-1993 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

#include "prototypes.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "tcl.h"
#include "tk.h"


#define MAXCLINE 156

/*
 * Declarations for various library procedures and variables (don't want
 * to include tkInt.h or tkConfig.h here, because people might copy this
 * file out of the Tk source directory to make their own modified versions).
 */

extern void exit _ANSI_ARGS_((int status));
extern int isatty _ANSI_ARGS_((int fd));
/*extern int            read _ANSI_ARGS_((int fd, char *buf, size_t size)); */
extern char *strrchr _ANSI_ARGS_((CONST char *string, int c));
extern char WWW_UI[];
extern char NT_UI[];
extern char GENERIC[];
/*
 * Global variables used by the main program:
 */

static Tk_Window mainWindow;	/* The main window for the application.  If
				 * NULL then the application no longer
				 * exists. */
Tcl_Interp *interp;		/* Interpreter for this application. */
static Tcl_DString command;	/* Used to assemble lines of terminal input
				 * into Tcl commands. */
static int tty;			/* Non-zero means standard input is a
				 * terminal-like device.  Zero means it's
				 * a file. */
static char errorExitCmd[] = "exit 1";

/*
 * Command-line options:
 */

static char *fileName = NULL;
static char *geometry = NULL;

/*
 * Declaration for Tcl command procedure to create demo widget.  This
 * procedure is only invoked if SQUARE_DEMO is defined.
 */

extern int SquareCmd _ANSI_ARGS_((ClientData clientData,
			   Tcl_Interp * interp, int argc, char *argv[]));


int ui_init(argc, argv, wname)
int argc;			/* Number of arguments. */
char **argv;			/* Array of argument strings. */
char *wname;
{
    char *cmd_line_args, buffer[10];
    char buf[MAXCLINE];

    putenv("TCL_LIBRARY=");	/* _putenv is win32 specific */
    putenv("TK_LIBRARY=");

    Tcl_FindExecutable(argv[0]);
    interp = Tcl_CreateInterp();
    cmd_line_args = Tcl_Merge(argc - 1, argv + 1);
    Tcl_SetVar(interp, "argv", cmd_line_args, TCL_GLOBAL_ONLY);
    sprintf(buffer, "%d", argc - 1);
    Tcl_SetVar(interp, "argc", buffer, TCL_GLOBAL_ONLY);
    Tcl_SetVar(interp, "argv0", argv[0], TCL_GLOBAL_ONLY);
    Tcl_SetVar(interp, "tcl_interactive", "0", TCL_GLOBAL_ONLY);
    Tcl_SetVar(interp, "NT_VERSION", NT_VERSION, TCL_GLOBAL_ONLY);
    Tk_MainWindow(interp);
    Tcl_Init(interp);
    Tk_Init(interp);

    sprintf(buf, "wm title . \"%s\"", wname);
    Tcl_Eval(interp, buf);

    /*
     * Add a few application-specific commands to the application's
     * interpreter.
     */

#ifdef SQUARE_DEMO
    Tcl_CreateCommand(interp, "square", SquareCmd, (ClientData) mainWindow,
		      (void (*)()) NULL);
#endif

    Tcl_CreateCommand(interp, "ui_quit", ui_quit,
		      (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ui_new_block", ui_new_block,
		      (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ui_delete_block", ui_delete_block,
		      (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ui_new_line", ui_new_line,
		      (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ui_set_line", ui_set_line,
		      (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ui_delete_line", ui_delete_line,
		      (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ui_find_line_len", ui_find_line_len,
		      (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ui_find_block_len", ui_find_block_len,
		      (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ui_findblock", ui_findblock,
		      (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ui_load_text_file", ui_load_text_file,
		      (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ui_load_struct_file", ui_load_struct_file,
		      (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ui_save_text_file", ui_save_text_file,
		      (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ui_save_struct_file", ui_save_struct_file,
		      (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ui_generate_id", ui_generate_id,
		      (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ui_set_my_colour", ui_set_my_colour,
		      (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ui_set_block_colour", ui_set_block_colour,
		      (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ui_set_block_font", ui_set_block_font,
		      (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ui_set_block_posn", ui_set_block_posn,
		      (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ui_print_ds", print_ds,
		      (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ui_get_creator", ui_get_creator,
		      (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ui_get_modifier", ui_get_modifier,
		      (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ui_get_modification_time",
		      ui_get_modification_time,
		      (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ui_get_lock_status",
		      ui_get_lock_status,
		      (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ui_get_my_lock_status",
		      ui_get_my_lock_status,
		      (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ui_set_lock_mode",
		      ui_set_lock_mode,
		      (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ui_send_shared_pointer",
		      ui_send_shared_pointer,
		      (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ui_keep_userlist",
		      ui_keep_userlist,
		      (ClientData) mainWindow, (void (*)()) NULL);
    /* extra commands v1.5a25 for undeleting blocks */
    Tcl_CreateCommand(interp, "ui_undelete_block", ui_undelete_block,
		      (ClientData) mainWindow, (void (*)()) NULL);
    /* exra commands v1.5a30 for cut, copy and paste */
    Tcl_CreateCommand(interp, "ui_copy_block", ui_copy_block,
		      (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ui_paste_block", ui_paste_block,
		      (ClientData) mainWindow, (void (*)()) NULL);
    /* extra commands v1.5.30 for checking block length variables,
       before inserting a new line into a block */
    Tcl_CreateCommand(interp, "ui_get_block_length", ui_get_block_length,
		      (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ui_get_max_block_size", ui_get_max_block_size,
		      (ClientData) mainWindow, (void (*)()) NULL);
    /* extra command v1.5.30 for de-activating the checksum protocol */
    Tcl_CreateCommand(interp, "ui_set_checksum_status", ui_set_checksum_status,
		      (ClientData) mainWindow, (void (*)()) NULL);
	Tcl_CreateCommand(interp, "ui_active_block", ui_active_block,
		      (ClientData) mainWindow, (void (*)()) NULL);
    /* end extra commands */


    /*register WWW stuff */
    Tcl_CreateCommand(interp, "webto", webto, (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "save_www_data_to_file", save_www_data_to_file, (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "stop_www_loading", stop_www_loading, (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "getustimeofday", uigetustimeofday, (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "get_participant_by_number", ui_get_participant_by_number, (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "set_encryption_key", ui_set_encryption_key, (ClientData) mainWindow, (void (*)()) NULL);
    Tcl_CreateCommand(interp, "reset_participants", ui_reset_participants, (ClientData) mainWindow, (void (*)()) NULL);
#ifdef WIN32
    Tcl_CreateCommand(interp, "debug", Debug, (ClientData) mainWindow, (void (*)()) NULL);
#endif
    return 1;
}

int ui_create_interface(int participants)
{
    int code;
    char *msg;
    char part_str[80];

#ifndef WIN32
    if (Tcl_AppInit(interp) != TCL_OK) {
	fprintf(stderr, "Tcl_AppInit failed: %s\n", interp->result);
    }
#endif

    /*
     * Set the geometry of the main window, if requested.
     */

    if (geometry != NULL) {
	code = Tcl_VarEval(interp, "wm geometry . ", geometry, (char *) NULL);
	if (code != TCL_OK) {
	    debug("%s\n", interp->result);
	}
    }
    /*
     * Invoke the script specified on the command line, if any.
     */

    if (fileName != NULL) {
	code = Tcl_VarEval(interp, "source ", fileName, (char *) NULL);
	if (code != TCL_OK) {
	    goto error;
	}
	tty = 0;
    } else {
	/*
	 * Commands will come from standard input, so set up an event
	 * handler for standard input.  If the input device is aEvaluate the
	 * .rc file, if one has been specified, set up an event handler
	 * for standard input, and print a prompt if the input
	 * device is a terminal.
	 */

#ifdef NOTDEF
	if (tcl_RcFileName != NULL) {
	    Tcl_DString buffer;
	    char *fullName;
	    FILE *f;

	    fullName = Tcl_TildeSubst(interp, tcl_RcFileName, &buffer);
	    if (fullName == NULL) {
		debug("%s\n", interp->result);
	    } else {
		f = fopen(fullName, "r");
		if (f != NULL) {
		    code = Tcl_EvalFile(interp, fullName);
		    if (code != TCL_OK) {
			debug("%s\n", interp->result);
		    }
		    fclose(f);
		}
	    }
	    Tcl_DStringFree(&buffer);
	}
#endif
	if (participants != -1) {
	    sprintf(part_str, "option add *participants %d interactive",
		    participants);
            Tcl_EvalObj(interp, Tcl_NewStringObj(part_str, strlen(part_str)));
	}

	if (Tcl_EvalObj(interp, Tcl_NewStringObj(GENERIC, strlen(GENERIC))) != TCL_OK) {
	    Tcl_AddErrorInfo(interp, "\n");
	    debug("GENERIC: %s\n", Tcl_GetStringResult(interp));
	}

	if (Tcl_EvalObj(interp, Tcl_NewStringObj(WWW_UI, strlen(WWW_UI))) != TCL_OK) {
	    Tcl_AddErrorInfo(interp, "\n");
	    debug("WWW_UI: %s\n", Tcl_GetStringResult(interp));
	}

	if (Tcl_EvalObj(interp, Tcl_NewStringObj(NT_UI, strlen(NT_UI))) != TCL_OK) {
	    Tcl_AddErrorInfo(interp, "\n");
	    debug("NT_UI: %s\n", Tcl_GetStringResult(interp));
	}

#ifdef NOTDEF
	Tk_CreateFileHandler(0, TK_READABLE, StdinProc, (ClientData) 0);
	if (tty) {
	    Prompt(interp, 0);
	}
#endif
    }
    fflush(stdout);
    Tcl_DStringInit(&command);

    /*
     * Add a filehandler for the network receive socket
     */
    //linksocket(rx_fd, TK_READABLE, (Tk_FileProc *) xsockrecv);	/* jim fix to cast pointer */
    return 0;

  error:
    msg = Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY);
    if (msg == NULL) {
	msg = interp->result;
    }
    fprintf(stderr, "%s\n", msg);
    Tcl_Eval(interp, errorExitCmd);
    return 1;			/* Needed only to prevent compiler warnings. */
}
