#include <tk.h>

#define INITIAL_MASK 6  /*must be in the range 1-16*/
                        /*2^INITIAL_MASK is expected max conf size*/
#define INITIAL_CONF_SIZE 64   

/*number of times to send token before sliding mask*/                    
#define TOKENS_PER_MASK_POSN 3 

#define RTX_TOKEN_STOP 255

/*the maximum number of times you can request something from
  the same match of the key.   after this, the key is reset.
  mostly a precaution against misbehaving clients grabbing a sliding
  key and holding it indefinitely*/
#define MAX_NO_OF_HOLDS 50

typedef struct 
{
  u_int16 key;
  u_int8 mask;
  u_int8 master; /*TRUE if we should restart sending after this cycle*/
  u_int8 mods; /*TRUE if a mod happened during this cycle*/
  u_int8 counter; /*counts the transmissions of each mask position*/
  u_int8 pass;  /*counts the number of successive key cycles*/
  u_int8 holds;
  struct timeval timestamp;
  Tk_TimerToken event_token;  
} sliding_key;
