#include "prototypes.h"
#ifdef WIN32
#include <windows.h>
#else
#include <stdio.h>
#endif

void debug(const char *fmt,...)
{
#ifdef DEBUG
#ifdef WIN32
    char szTemp[512];
    va_list ap;
    va_start(ap, fmt);
    wvsprintf(szTemp, fmt, ap);
    OutputDebugString(szTemp);
    va_end(ap);
#else
    va_list ap;

    va_start(ap, fmt);
    vfprintf(stderr, fmt, ap);
    va_end(ap);
#endif
#else
    UNUSED(fmt);
#endif
}

#ifdef WIN32
int
Debug(clientData, interp, argc, argv)
    ClientData clientData;
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
    char *message;
	char szTemp[512]; 
	va_list ap;	
	
	message = argv[1];
    va_start (ap, message);
#ifdef WIN32
    wvsprintf(szTemp, message, ap);
    OutputDebugString(szTemp);
#else
    vfprintf(stderr, message, ap);
#endif
    va_end (ap);

	return (TCL_OK);
}
#endif
