/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.StackTarget;
import gnu.expr.Target;

public class SeriesTarget
extends Target {
    public Variable value;
    public Label function;
    public Label done;

    public void compileFromStackSimple(Compilation comp, Type stackType) {
        CodeAttr code = comp.getCode();
        StackTarget.convert(comp, stackType, this.value.getType());
        code.emitStore(this.value);
        code.emitJsr(this.function);
    }

    public void compileFromStack(Compilation comp, Type stackType) {
        CodeAttr code = comp.getCode();
        if (SeriesTarget.isSingletonType(stackType)) {
            this.compileFromStackSimple(comp, stackType);
            return;
        }
        Variable indexVar = code.addLocal(Type.int_type);
        Variable valuesVar = code.addLocal(Type.pointer_type);
        Variable nextVar = code.addLocal(Type.int_type);
        StackTarget.convert(comp, stackType, Type.pointer_type);
        code.emitStore(valuesVar);
        code.emitPushInt(0);
        code.emitStore(indexVar);
        Label top = new Label(code);
        top.define(code);
        code.emitLoad(valuesVar);
        code.emitLoad(indexVar);
        code.emitInvokeStatic(Compilation.typeValues.getDeclaredMethod("nextIndex", 2));
        code.emitDup(Type.int_type);
        code.emitStore(nextVar);
        code.emitGotoIfIntLtZero(this.done);
        code.emitLoad(valuesVar);
        code.emitLoad(indexVar);
        code.emitInvokeStatic(Compilation.typeValues.getDeclaredMethod("nextValue", 2));
        this.compileFromStackSimple(comp, Type.pointer_type);
        code.emitLoad(nextVar);
        code.emitStore(indexVar);
        code.emitGoto(top);
    }

    public Type getType() {
        return Type.pointer_type;
    }

    public static boolean isSingletonType(Type type) {
        int cmp;
        if (type instanceof PrimType) {
            return !type.isVoid();
        }
        if (type instanceof ArrayType) {
            return true;
        }
        return type instanceof ClassType && (cmp = type.compare(Compilation.typeValues)) == -3;
    }
}

