#ifndef KP_COMMENT_H_
#define KP_COMMENT_H_

#include <glib.h>
#include <glib-object.h>
#include <libxml/tree.h>

#include "kpcalendarentry.h"

#define KP_TYPE_COMMENT (kp_comment_get_type())
#define KP_COMMENT(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), KP_TYPE_COMMENT, KPComment))
#define KP_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KP_TYPE_COMMENT, KPCommentClass))
#define KP_IS_COMMENT(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), KP_TYPE_COMMENT))
#define KP_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KP_TYPE_COMMENT))
#define KP_COMMENT_GET_CLASS(object) (G_TYPE_INSTANCE_GET_CLASS ((object), KP_TYPE_COMMENT, KPCommentClass))

typedef struct KPComment_
{
  KPCalendarEntry   parent_instance;

  GString        *title;
  GString        *text;
}
KPComment;

typedef struct KPCommentClass_ {
  KPCalendarEntryClass parent_class;  
} KPCommentClass;

KPComment      *kp_comment_new (const gchar *title, const gchar *text);
GType           kp_comment_get_type ();

void            kp_comment_set_title (KPComment * comment, const gchar *title);
void            kp_comment_set_text (KPComment * comment, const gchar *text);

gchar          *kp_comment_get_title (KPComment * comment);
gchar          *kp_comment_get_text (KPComment * comment);

gchar          *kp_comment_get_formatted_date (KPComment * comment);

#endif
