/*
 *  kipina.c
 *  (C) 2002,2003 Ville Kangas <ville@mirjami.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include <glade/glade.h>
#include <gtk/gtk.h>

#include "gui/kpmainwindow.h"
#include "gui/kpguiutils.h"
#include "kipina-i18n.h"
#include "kpsettings.h"
#include "kpplugin.h"
#include "kipina.h"
#include "kputil.h"

#define MAX_CMD_LINE_LEN 15

static void       gui_init                (gint *argc, gchar ***argv,
                                           const gchar *file);

int
main (int argc, char **argv)
{
  gchar *file = NULL;

  if (argc > 2) {
    fprintf (stderr, "Usage: ./%s [FILE]\n", argv[0]);
    return EXIT_FAILURE;
  }

  if (argc == 2)
    file = argv[1];

  bindtextdomain (GETTEXT_PACKAGE, KIPINA_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
  setlocale (LC_ALL, "");

  g_type_init ();

  kp_settings_init (NULL);
  kp_plugin_scan (NULL);

  gui_init (&argc, &argv, file);
 
  return 0;
}


static void
gui_init (gint *argc, gchar ***argv, const gchar *file)
{
  GtkWidget *window;
  gtk_init (argc, argv);
  glade_init ();

  window = kp_main_window_new ();
  gtk_widget_show (window);

  kp_main_window_set_log_file (KP_MAIN_WINDOW (window), file);
  
  gtk_main ();
}

