/*  Inti-GL: Integrated Foundation Classes
 *  Copyright (C) 2003 The Inti Development Team.
 *
 *  config.cc - GdkGLConfig C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "config.h"
#include "private/config_p.h"
#include <inti/gdk/color.h>
#include <inti/gdk/screen.h>
#include <inti/gdk/visual.h>

using namespace Inti;

/*  Gdk::GL::Config
 */

Gdk::GL::Config::Config(GdkGLConfig *config, bool reference)
: G::Object((GObject*)config, reference)
{
}

Gdk::GL::Config::~Config()
{
}

Pointer<Gdk::GL::Config>
Gdk::GL::Config::create(const int *attrib_list, const Gdk::Screen *screen)
{
	GdkScreen *tmp_screen = screen ? screen->gdk_screen() : gdk_screen_get_default();
	return G::Object::wrap<Config>(gdk_gl_config_new_for_screen(tmp_screen, attrib_list));
}

Pointer<Gdk::GL::Config>
Gdk::GL::Config::create(ConfigModeField mode, const Gdk::Screen *screen)
{
	GdkScreen *tmp_screen = screen ? screen->gdk_screen() : gdk_screen_get_default();
	return G::Object::wrap<Config>(gdk_gl_config_new_by_mode_for_screen(tmp_screen, (GdkGLConfigMode)mode));
}

GdkGLConfigClass*
Gdk::GL::Config::gdk_gl_config_class() const
{
	return get_class<GdkGLConfigClass>();
}

Gdk::GL::Config::operator GdkGLConfig* () const
{
	return this ? gdk_gl_config() : 0;
}

Gdk::Screen*
Gdk::GL::Config::get_screen() const
{
	return G::Object::wrap<Gdk::Screen>(gdk_gl_config_get_screen(gdk_gl_config()));
}

bool
Gdk::GL::Config::get_attrib(int attribute, int& value)
{
	return gdk_gl_config_get_attrib(gdk_gl_config(), attribute, &value);
}

Gdk::Colormap* 
Gdk::GL::Config::get_colormap() const
{
	return G::Object::wrap<Gdk::Colormap>(gdk_gl_config_get_colormap(gdk_gl_config()));
}

Gdk::Visual* 
Gdk::GL::Config::get_visual() const
{
	return G::Object::wrap<Gdk::Visual>(gdk_gl_config_get_visual(gdk_gl_config()));
}

int 
Gdk::GL::Config::get_depth() const
{
	return gdk_gl_config_get_depth(gdk_gl_config());
}

int 
Gdk::GL::Config::get_layer_plane() const
{
	return gdk_gl_config_get_layer_plane(gdk_gl_config());
}

int 
Gdk::GL::Config::get_n_aux_buffers() const
{
	return gdk_gl_config_get_n_aux_buffers(gdk_gl_config());
}

int 
Gdk::GL::Config::get_n_sample_buffers() const
{
	return gdk_gl_config_get_n_sample_buffers(gdk_gl_config());
}

bool 
Gdk::GL::Config::is_rgba() const
{
	return gdk_gl_config_is_rgba(gdk_gl_config());
}

bool 
Gdk::GL::Config::is_double_buffered() const
{
	return gdk_gl_config_is_double_buffered(gdk_gl_config());
}

bool 
Gdk::GL::Config::is_stereo() const
{
	return gdk_gl_config_is_stereo(gdk_gl_config());
}

bool 
Gdk::GL::Config::has_alpha() const
{
	return gdk_gl_config_has_alpha(gdk_gl_config());
}

bool 
Gdk::GL::Config::has_depth_buffer() const
{
	return gdk_gl_config_has_depth_buffer(gdk_gl_config());
}

bool 
Gdk::GL::Config::has_stencil_buffer() const
{
	return gdk_gl_config_has_stencil_buffer(gdk_gl_config());
}

bool 
Gdk::GL::Config::has_accum_buffer() const
{
	return gdk_gl_config_has_accum_buffer(gdk_gl_config());
}

/*  Gdk::GL::ConfigClass
 */

void
Gdk::GL::ConfigClass::init(GdkGLConfigClass *g_class)
{
	G::ObjectClass::init((GObjectClass*)g_class);
}

GType
Gdk::GL::ConfigClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GDK_TYPE_GL_CONFIG, (GClassInitFunc)init);
	}
	return type;
}

void*
Gdk::GL::ConfigClass::create()
{
	return g_object_new(get_type(), 0);
}

