/*
 *  PGDescriptor.m
 *  graphviz
 *
 *  Created by Glen Low on Thu Jan 07 2004.
 *  Copyright (c) 2004, Pixelglow Software. All rights reserved.
 *  http://www.pixelglow.com/graphviz/
 *  graphviz@pixelglow.com
 *
 *  Redistribution and use in source and binary forms, with or without modification, are permitted
 *  provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this list of conditions
 *    and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice, this list of conditions
 *    and the following disclaimer in the documentation and/or other materials provided with the distribution.
 *  * Neither the name of Pixelglow Software nor the names of its contributors may be used to endorse or
 *    promote products derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 *  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#import "PGDescriptor.h"

static NSMutableDictionary* allDescriptors_ = nil;

@implementation PGDescriptor

+ (void) initialize
	{
		if (!allDescriptors_)
			allDescriptors_ = [[NSMutableDictionary alloc] init];
	}
	
+ (PGDescriptor*) descriptorForScope: (NSString*) scope name: (NSString*) name
	{
		return [allDescriptors_ objectForKey: [NSString stringWithFormat: @"%@.%@", scope, name]];
	}

- (id) initWithScope: (NSString*) scope name: (NSString*) name
	{
		if (scope && name)
			return [self initWithScope: scope name: name tip: nil description: nil];
		else
			{
				if ((self = [super init]))
					{
						name_ = [name copy];
						tip_ = nil;
						description_ = @"";
					}
				return self;
			}
	}

- (id) initWithScope: (NSString*) scope name: (NSString*) name tip: (NSString*) tip description: (NSString*) description
	{
		if ((self = [super init]))
			{
				NSString* scoped = [NSString stringWithFormat: @"%@.%@", scope, name];
				NSBundle* mainBundle = [NSBundle mainBundle];
				
				name_ = [name copy];
				
				if (tip)
					tip_ = [tip copy];
				else
					{
						NSString* localTip = [mainBundle localizedStringForKey: scoped value: nil table: @"ToolTips"];
						tip_ = [scoped isEqualToString: localTip] ? nil : [localTip retain];
					}
					
				if (description)
					description_ = [description copy];
				else
					description_ = [[mainBundle localizedStringForKey: scoped value: name table: @"Descriptions"] retain];
						
				[allDescriptors_ setObject: self forKey: scoped];
			}
		return self;
	}
	
- (id) copyWithZone: (NSZone*) zone
	{
		return [self retain];   // we are immutable
	}
	
- (BOOL) isEqual: (id) other
	{
		return [other respondsToSelector: @selector (name)] && [name_ isEqual: [other performSelector: @selector (name)]];
	}
	
- (NSString*) name
	{
		return name_;
	}

- (NSString*) tip
	{
		return tip_;
	}
	
- (NSString*) description
	{
		return description_;
	}

- (NSComparisonResult) compare: (PGDescriptor*) other
	{
		return [description_ compare: [other description]];
	}

- (void) dealloc
	{
		[name_ release];
		[tip_ release];
		[description_ release];
		
		[super dealloc];
	}
@end


