/* $Id: cairogen-png.c,v 1.3 2004/12/11 19:26:05 ellson Exp $ $Revision: 1.3 $ */
/* vim:set shiftwidth=4 ts=8: */

/**********************************************************
*      This software is part of the graphviz package      *
*                http://www.graphviz.org/                 *
*                                                         *
*            Copyright (c) 1994-2004 AT&T Corp.           *
*                and is licensed under the                *
*            Common Public License, Version 1.0           *
*                      by AT&T Corp.                      *
*                                                         *
*        Information and Software Systems Research        *
*              AT&T Research, Florham Park NJ             *
**********************************************************/

/* cairogen_png.c */
/*    code adapted from xsvg.c by John Ellson <ellson@research.att.com> */

/* xsvg - SVG viewer application for the X Window System
 *
 * Copyright © 2002 USC/Information Sciences Institute
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice
 * appear in supporting documentation, and that the name of
 * Information Sciences Institute not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  Information Sciences Institute
 * makes no representations about the suitability of this software for
 * any purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * INFORMATION SCIENCES INSTITUTE DISCLAIMS ALL WARRANTIES WITH REGARD
 * TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL INFORMATION SCIENCES
 * INSTITUTE BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Carl Worth <cworth@isi.edu>
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#ifdef HAVE_LIBSVG_CAIRO

#include <stdio.h>
#include <stdlib.h>
#include <png.h>
#include <svg-cairo.h>
#include "cairogen-png.h"

static svg_status_t
write_png_argb32(char *buffer, FILE * f,
		 int width, int height, int stride);

/* XXX: We should make the -fit option work for scaling the PNG output. */
int
render_to_png(svg_cairo_t * svgc, FILE * png_file, double scale, int width,
	      int height)
{
    cairo_t *cr;
    char *image;

    if (width < 0 || height < 0) {
	svg_cairo_get_size(svgc, &width, &height);
	width = (width * scale + 0.5);
	height = (height * scale + 0.5);
    }

    image = calloc(width * height, 4);
    if (!image)
	return 1;

    cr = cairo_create();
    cairo_scale(cr, scale, scale);

    cairo_set_target_image(cr, image, CAIRO_FORMAT_ARGB32, width, height,
			   width * 4);

    /* XXX: This probably doesn't need to be here (eventually) */
    cairo_set_rgb_color(cr, 1, 1, 1);

    svg_cairo_render(svgc, cr);

    write_png_argb32(image, png_file, width, height, width * 4);

    cairo_destroy(cr);
    free(image);
    return 0;
}

static void
unpremultiply_data(png_structp png, png_row_infop row_info, png_bytep data)
{
    int i;

    for (i = 0; i < row_info->rowbytes; i += 4) {
	unsigned char *b = &data[i];
	unsigned char alpha = b[3];
	unsigned long pixel;
	unsigned long *p;
	if (alpha == 0)
	    pixel = 0;
	else
	    pixel = ((((b[0] * 255) / alpha) << 0) |
		     (((b[1] * 255) / alpha) << 8) |
		     (((b[2] * 255) / alpha) << 16) | (alpha << 24));
	p = (unsigned long *) b;
	*p = pixel;
    }
}

static svg_status_t
write_png_argb32(char *buffer, FILE * f, int width, int height, int stride)
{
    png_struct *png;
    png_info *info;
    png_byte **rows;
    int i;
    png_color_16 white;

    if (!f)
	return SVG_STATUS_IO_ERROR;

    rows = malloc(height * sizeof(png_byte *));

    for (i = 0; i < height; i++) {
	rows[i] = buffer + i * stride;
    }

    png = png_create_write_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);
    info = png_create_info_struct(png);

    png_init_io(png, f);
    png_set_IHDR(png, info,
		 width, height, 8,
		 PNG_COLOR_TYPE_RGB_ALPHA,
		 PNG_INTERLACE_NONE,
		 PNG_COMPRESSION_TYPE_DEFAULT, PNG_FILTER_TYPE_DEFAULT);

    white.red = 0xff;
    white.blue = 0xff;
    white.green = 0xff;
    png_set_bKGD(png, info, &white);

    png_set_write_user_transform_fn(png, unpremultiply_data);
    png_set_bgr(png);

    png_write_info(png, info);
    png_write_image(png, rows);
    png_write_end(png, info);

    png_destroy_write_struct(&png, &info);

    free(rows);
    fflush(f);

    return SVG_STATUS_SUCCESS;
}

#endif				/* HAVE_LIBSVG_CAIRO */
