/* Copyright (C) 2004 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYING distributed with the source files.

*/

#ifndef TRAY_ICON_H
#define TRAY_ICON_H

#include "prog_defs.h"

#include <gtkmm/menu.h>
#include <gtkmm/menuitem.h>
#include <gtkmm/window.h>

#include <gtk/gtkwidget.h>
#include <gtk/gtktooltips.h>
#include <gdk/gdkevents.h>

#include <sigc++/sigc++.h>

extern "C" {
#include "libegg/eggtrayicon.h"
void embedded_cback(GtkWidget*, gpointer);
void destroy_cback(GtkWidget*, gpointer);
gboolean button_press_cback(GtkWidget* , GdkEventButton*, gpointer);
}

class TrayItem: public sigc::trackable {

  // needed for the GTK+ callbacks
  static TrayItem* tray_item_p;

  Gtk::Window& prog_window;
  bool embedded;
  EggTrayIcon* tray_icon_p;
  GtkWidget* event_box_p;
  GtkTooltips* tooltips_p;

  Gtk::Menu popup_menu;
  Gtk::MenuItem* stop_item_p;
  Gtk::MenuItem* receive_standby_item_p;
  Gtk::MenuItem* receive_answer_item_p;
  Gtk::MenuItem* receive_takeover_item_p;

  void popup_menu_slot(int);
  void tray_icon_init(void);
  void tray_icon_destroy(void);
  void button_press_handler(GdkEventButton*);

  // not to be copied or assigned
  void operator=(const TrayItem&);
  TrayItem(const TrayItem&);
public:
  enum MenuItem {quit, stop, receive_standby, receive_answer, receive_takeover,
		 list_received_faxes, list_sent_faxes};

  sigc::signal0<void> left_button_pressed;
  sigc::signal1<void, int> menu_item_chosen;
  sigc::signal0<int> get_state;

  friend void embedded_cback(GtkWidget*, gpointer);
  friend void destroy_cback(GtkWidget*, gpointer);
  friend gboolean button_press_cback(GtkWidget* , GdkEventButton*, gpointer);

  void set_tooltip_slot(const char* text);
  bool is_embedded(void) const {return embedded;}

  TrayItem(Gtk::Window&);
};

#endif
