(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** The data class. *)

open Dbf_types.Current



class data ?(gui=true) (dbms : Dbf_dbms.dbms_spec list)  file =
  object (self)
    val mutable schema = { sch_tables = [] }
    val mutable changed = false
    val mutable file = file

    method dbms = dbms
    method schema = schema


    method tables = schema.sch_tables

    method table_by_name n =
      List.find (fun t -> t.ta_name = n) schema.sch_tables

    method add_table t =
      try 
	ignore (self#table_by_name t.ta_name);
	raise (Failure (Dbf_messages.table_exists t.ta_name))
      with
	Not_found ->
	  schema.sch_tables <- t :: schema.sch_tables;
	  self#set_changed true

    method del_table t =
      schema.sch_tables <- 
	List.filter (fun ta -> t.ta_name <> ta.ta_name) schema.sch_tables;
      self#set_changed true


    method column_by_name t n =
      List.find (fun c -> c.col_name = n) t.ta_columns

    method add_column t c =
      try
	ignore (self#column_by_name t c.col_name);
	raise (Failure (Dbf_messages.column_exists c.col_name))
      with
	Not_found ->
	  t.ta_columns <- c :: t.ta_columns;
	  self#set_changed true

    method del_column t c =
      t.ta_columns <- 
	List.filter (fun c2 -> c2.col_name <> c.col_name) t.ta_columns;
      self#set_changed true


    method set_changed b = changed <- b
    method changed = changed
    method set_file f = file <- f
    method save = Dbf_types.write file schema

    method load =
      schema <- Dbf_types.read file;
      self#set_changed false

    method file = (file : string)

    initializer
      self#load
  end
