#import "NativeMethods.h"
#import "Conversions.h"

#ifndef GNUSTEP
#import <Carbon/Carbon.h>
#endif
#import <XSUB.h>

MODULE = CamelBones	PACKAGE = CamelBones

PROTOTYPES: ENABLE

void
NSLog(logString)
    SV *logString;
    CODE:
        NSLog([CBDerefSVtoID(logString) description]);

SV*
NSClassFromString(aString)
	SV *aString;
	CODE:
		RETVAL=CBSVFromClass(NSClassFromString(CBDerefSVtoID(aString)));
	OUTPUT:
		RETVAL

SV *
_callObjectMethod(object, sel, args)
    IV object;
    char * sel;
    SV *args;
    CODE:
        SV *ret = newSViv(0);
        id this = (id)object;
        if (this) {
            SEL s = NSSelectorFromString([NSString stringWithUTF8String: sel]);
            if ([[this class] instancesRespondToSelector: s]) {
                ret = CBCallNativeMethod(this, s, args);
            } else {
                NSLog(@"Instances of class %@ do not respond to selector %s", [this className], sel);
            }
        } else {
            NSLog(@"Invalid object reference");
        }
        RETVAL = ret;
    OUTPUT:
        RETVAL


SV *
_callClassMethod(classString, sel, args)
    char *classString;
    char * sel;
    SV *args;
    CODE:
        SV *ret = newSViv(0);
        Class class = NSClassFromString([NSString stringWithUTF8String: classString]);
        if (class) {
            SEL s = NSSelectorFromString([NSString stringWithUTF8String: sel]);
            if ([class respondsToSelector: s]) {
                ret = CBCallNativeMethod(class, s, args);
            } else {
                NSLog(@"Class %s does not respond to selector %s", classString, sel);
            }
        } else {
            NSLog(@"Unknown class %s", classString);
        }
        RETVAL = ret;
    OUTPUT:
        RETVAL

