#include "dns.h"

static const char* skip_name(const uint8* ptr, const uint8* end)
{
  uint8 len;
  while (ptr < end && (len = *ptr++) != 0) {
    if (len >= 0xc0)
      return ptr + 1;
    ptr += len;
  }
  return ptr;
}

int dns_packet_get(const str* pkt, str* out, uint16 type)
{
  const uint8* ptr;
  const uint8* end;
  unsigned i;
  unsigned count;
  ptr = pkt->s + dns_header_len;
  end = pkt->s + pkt->len;
  /* Skip over the queries section */
  for (i = 0; ptr < end && i < dns_header_qdcount(pkt->s); ++i)
    ptr = skip_name(ptr, end) + 4;
  if (ptr >= end) return -1;
  /* Enumerate over the answers */
  for (count = 0, i = 0; ptr < end && i < dns_header_ancount(pkt->s); ++i) {
    unsigned rdlength;
    ptr = skip_name(ptr, end);
    if (ptr + 10 > end) return -1;
    rdlength = uint16_get_msb(ptr+8);
    if (ptr + 10 + rdlength > end) return -1;
    if (uint16_get_msb(ptr) == type &&
	uint16_get_msb(ptr+2) == DNS_CLASS_IN) {
      if (!str_catb(out, ptr+8, 2+rdlength)) return -1;
      ++count;
    }
    ptr += 10 + rdlength;
  }
  return count;
}
