#include <string.h>

#include "dns.h"

static int dns_mx_base(int (*queryfn)(const char*, int, str*),
		       const char* domain, str* mxs)
{
  str packet = {0,0,0};
  str name = {0,0,0};
  str rrs = {0,0,0};
  int count = 0;
  if ((count = queryfn(domain, DNS_TYPE_MX, &packet)) > 0) {
    if ((count = dns_packet_get(&packet, &rrs, DNS_TYPE_MX)) > 0) {
      unsigned pos;
      unsigned len;
      mxs->len = 0;
      count = 0;
      for (pos = 0; pos < rrs.len+2; pos += len) {
	len = uint16_get_msb(rrs.s+pos);
	pos += 2;
	if (len >= 3 && pos + len <= rrs.len) {
	  str_catb(mxs, rrs.s+pos, 2);
	  name.len = 0;
	  dns_uncompress_name(rrs.s+pos+2, len-2, &packet, &name);
	  dns_name_to_dots(name.s, name.len, mxs);
	  str_catc(mxs, 0);
	  ++count;
	}
      }
    }
  }
  str_free(&rrs);
  str_free(&packet);
  str_free(&name);
  return count;
}

int dns_mx(const char* domain, str* mxs)
{
  return dns_mx_base(dns_query, domain, mxs);
}

int dns_mx_fqdn(const char* domain, str* mxs)
{
  return dns_mx_base(dns_query_fqdn, domain, mxs);
}
